using System;

public class Programme
{
    public static void Main(string[] args)
    {
        string[] input = Console.ReadLine().Split(' ');
        long n = long.Parse(input[0]);
        int k = int.Parse(input[1]);
        input = Console.ReadLine().Split(' ');
        long[] arr = new long[k];
        long[] unsortedArr = new long[k];
        for (int i = 0; i < k; i++)
        {
            arr[i] = long.Parse(input[i]);
            unsortedArr[i] = arr[i];
        }
        Array.Sort(arr);
        for (int i = 0; i < k; i++)
        {
            if (i == 0)
            {
                Console.Write(XOR(unsortedArr[i], factors(unsortedArr[i])));
            }
            else
            {
                Console.Write(" " + XOR(unsortedArr[i], factors(unsortedArr[i])));
            }
        }
    }
    public static long XOR(long number, long[] arr)
    {
        int n = Array.BinarySearch(arr, number);
        for (int i = 0; i < n; i++)
        {
            number ^= arr[i];
        }
        return number;
    }
    public static long[] factors(long n)
    {
        List<long> factors = new List<long>();
        for (long i = 1; i <= Math.Sqrt(n); i++)
        {
            if (n % i == 0)
            {
                factors.Add(i);
                if (i != n / i)
                {
                    factors.Add(n / i);
                }
            }
        }
        factors.Sort();
        return factors.ToArray();
    }
}